//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, Coordinated Motion - COMILX_MC_Line() or COMILX_MC_StartLine
// Contents: 
//     COMILX_MC_StartLine()Լ 뿹 ̱  Դϴ. 
//	   X Y࿡ Ͽ ǥ    ̵ մϴ. 
//	 ó ǥ (10000, 20000)    ̵ ϰ ٽ ǥ
//	 (-10000, -20000)   ̵ մϴ. 
// Remarks:
//    α׷ COMI-LX501  Դϴ. 
//*********************************************************************
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

// (ä) ȣ //
#define X_AXIS	0
#define Y_AXIS	1
// Axis Map    Mask //
#define X_MASK	1
#define Y_MASK	2
#define Z_MASK	4
#define U_MASK	8

#define MAP0	0

void main()
{
	double fPosList [2];
	double fXPos, fYPos;
	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure
	
	COMILX_MC_Reset(hDevice);

	// Map X&Y axis to MAP0 //
	COMILX_MC_MapAxes(hDevice, MAP0, X_MASK|Y_MASK);
	// Set speed mode as Trapezoidal //
	COMILX_MC_SetSpeedModeMx(hDevice, MAP0, 1);
	// Set speed & accel => V=10000,  Acc=10000 //
	COMILX_MC_SetSpeedMx(hDevice, MAP0, 10000, 10000);
	
	printf("Press any key to start motion\n");
	printf("Coordinated Motion (X&Y) : Relative coord. of (10000, 20000) \n");
	getch();
	
	// Move to absolute coord. (10000, 20000) //
	fPosList[0] = 10000;	fPosList[1] = 20000;
	COMILX_MC_StartLineTo(hDevice, MAP0, fDistList);
	// Coordinated Motion Ϸɶ ٸ. //
	while(!COMILX_MC_MxDone(hDevice, MAP0)){
		fXPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
		fYPos = COMILX_MC_GetPosition_C(hDevice, Y_AXIS);
		printf("Position (X, Y) = (%.0f, %.0f)\n", fXPos, fYPos);
	}
	printf("Coordinated Motion, relative coord of (10000, 20000), has been completed\n\n");
	printf("Press any key to start another motion\n");
	printf("Coordinated Motion (X&Y) : Relative coord. of (-10000, -20000) \n");
	getch();
	// Move to absolute coord. (0, 0) //
	fDistList[0] = 0;	fDistList[1] = 0;
	COMILX_MC_StartLineTo(hDevice, MAP0, fDistList);
	// Coordinated Motion Ϸɶ ٸ. //
	while(!COMILX_MC_MxDone(hDevice, MAP0)){
		fXPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
		fYPos = COMILX_MC_GetPosition_C(hDevice, Y_AXIS);
		printf("Position (X, Y) = (%.0f, %.0f)\n", fXPos, fYPos);
	}
	printf("Coordinated Motion, absolute coord of (0, 0), has been completed\n\n");
	getch();
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
